function [map, x_range, y_range] = kernel_density( x, y, bandwidth )

%Computes a gaussian kernel based density estimate of the points (x,y)
%Karthik Shekhar, MIT


%Params (can be changed)
width = 400; height = 400;

%Limits and deltax, deltay
limits(1) = min(x)-5;
limits(2) = max(x)+5;
limits(3) = min(y)-5;
limits(4) = max(y)+5;

deltax = (limits(2) - limits(1)) / width;
deltay = (limits(4) - limits(3)) / height;

if ~exist('bandwidth','var')
    disp('ERROR : must specify a value of the kernel bandwidth. Exiting...')
    return
end

map = zeros(height, width);

for ii = 0: height - 1
        yi = limits(3) + ii * deltay + deltay/2;
        for jj = 0 : width - 1
            xi = limits(1) + jj * deltax + deltax/2;
            
            
            dist2 = (x - xi).^2 + (y - yi).^2;
            dd = sum(exp(-dist2./(2*bandwidth^2))); 

            map(ii+1,jj+1) = (1/sqrt(2*pi*bandwidth^2)) * dd;
        end
end
            
    for ii=0:height-1
        y_range(ii+1) = limits(3) + ii * deltay + deltay/2;
    end
    for jj=0:width-1
        x_range(jj+1) = limits(1) + jj * deltax + deltax/2;
    end
    
    
    
    map = map/sum(map(:)); %Convert to PDF 
    
    map(find(map < 5e-8))=0; 

    
    
end

